Public Class Form1

    Const CRC_SEED = &H18
    ' CRC-8 Look-up Table
    Dim CRC8LUT() As Byte = { _
    &H0, &H18, &H30, &H28, &H60, &H78, &H50, &H48, &HC0, &HD8, &HF0, &HE8, &HA0, &HB8, &H90, &H88, _
    &H98, &H80, &HA8, &HB0, &HF8, &HE0, &HC8, &HD0, &H58, &H40, &H68, &H70, &H38, &H20, &H8, &H10, _
    &H28, &H30, &H18, &H0, &H48, &H50, &H78, &H60, &HE8, &HF0, &HD8, &HC0, &H88, &H90, &HB8, &HA0, _
    &HB0, &HA8, &H80, &H98, &HD0, &HC8, &HE0, &HF8, &H70, &H68, &H40, &H58, &H10, &H8, &H20, &H38, _
    &H50, &H48, &H60, &H78, &H30, &H28, &H0, &H18, &H90, &H88, &HA0, &HB8, &HF0, &HE8, &HC0, &HD8, _
    &HC8, &HD0, &HF8, &HE0, &HA8, &HB0, &H98, &H80, &H8, &H10, &H38, &H20, &H68, &H70, &H58, &H40, _
    &H78, &H60, &H48, &H50, &H18, &H0, &H28, &H30, &HB8, &HA0, &H88, &H90, &HD8, &HC0, &HE8, &HF0, _
    &HE0, &HF8, &HD0, &HC8, &H80, &H98, &HB0, &HA8, &H20, &H38, &H10, &H8, &H40, &H58, &H70, &H68, _
    &HA0, &HB8, &H90, &H88, &HC0, &HD8, &HF0, &HE8, &H60, &H78, &H50, &H48, &H0, &H18, &H30, &H28, _
    &H38, &H20, &H8, &H10, &H58, &H40, &H68, &H70, &HF8, &HE0, &HC8, &HD0, &H98, &H80, &HA8, &HB0, _
    &H88, &H90, &HB8, &HA0, &HE8, &HF0, &HD8, &HC0, &H48, &H50, &H78, &H60, &H28, &H30, &H18, &H0, _
    &H10, &H8, &H20, &H38, &H70, &H68, &H40, &H58, &HD0, &HC8, &HE0, &HF8, &HB0, &HA8, &H80, &H98, _
    &HF0, &HE8, &HC0, &HD8, &H90, &H88, &HA0, &HB8, &H30, &H28, &H0, &H18, &H50, &H48, &H60, &H78, _
    &H68, &H70, &H58, &H40, &H8, &H10, &H38, &H20, &HA8, &HB0, &H98, &H80, &HC8, &HD0, &HF8, &HE0, _
    &HD8, &HC0, &HE8, &HF0, &HB8, &HA0, &H88, &H90, &H18, &H0, &H28, &H30, &H78, &H60, &H48, &H50, _
    &H40, &H58, &H70, &H68, &H20, &H38, &H10, &H8, &H80, &H98, &HB0, &HA8, &HE0, &HF8, &HD0, &HC8 _
    }

    Const START As Byte = &HFF

    Dim rx_i As Integer = 9
    Dim rx_data(8) As Byte

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        ' close serial port
        Try
            If serCOM.IsOpen Then
                serCOM.Close()
                serCOM.Dispose()
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        System.Windows.Forms.Control.CheckForIllegalCrossThreadCalls = False

        cmbPort.SelectedItem = "COM1"
        cmbRate.SelectedItem = "9600"
        cmbParity.SelectedItem = "No Parity"
        cmbBits.SelectedItem = "8 Bits"
        cmbStop.SelectedItem = "1 Stop"

        cmbXBeeRate.SelectedItem = "9600 (ATBD3<CR>)"
        cmbXBeeParity.SelectedItem = "No Parity (ATNB0<CR>)"
        cmbXBeeCh.SelectedItem = "Default Channel (ATCH0C<CR>)"
    End Sub

    Private Sub btnConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        Try
            If serCOM.IsOpen Then
                serCOM.Close()
                btnConnect.Text = "Connect"
                cmbPort.Enabled = True
                cmbRate.Enabled = True
                cmbParity.Enabled = True
                cmbBits.Enabled = True
                cmbStop.Enabled = True
            Else
                serCOM.PortName = cmbPort.SelectedItem
                serCOM.BaudRate = cmbRate.SelectedItem
                Select Case cmbParity.SelectedItem
                    Case "No Parity"
                        serCOM.Parity = IO.Ports.Parity.None
                        Exit Select
                    Case "Even Parity"
                        serCOM.Parity = IO.Ports.Parity.Even
                        Exit Select
                    Case "Odd Parity"
                        serCOM.Parity = IO.Ports.Parity.Odd
                        Exit Select
                    Case Else
                        serCOM.Parity = IO.Ports.Parity.None
                        Exit Select
                End Select
                Select Case cmbBits.SelectedItem
                    Case "7 Bits"
                        serCOM.DataBits = 7
                        Exit Select
                    Case "8 Bits"
                        serCOM.DataBits = 8
                        Exit Select
                    Case "Odd Parity"
                        serCOM.DataBits = 9
                        Exit Select
                    Case Else
                        serCOM.DataBits = 8
                        Exit Select
                End Select
                Select Case cmbStop.SelectedItem
                    Case "1 Stop"
                        serCOM.StopBits = IO.Ports.StopBits.One
                        Exit Select
                    Case "1.5 Stop"
                        serCOM.StopBits = IO.Ports.StopBits.OnePointFive
                        Exit Select
                    Case "2 Stop"
                        serCOM.StopBits = IO.Ports.StopBits.Two
                        Exit Select
                    Case Else
                        serCOM.StopBits = IO.Ports.StopBits.One
                        Exit Select
                End Select
                serCOM.DtrEnable = chkDTR.Checked
                serCOM.RtsEnable = chkRTS.Checked
                serCOM.Open()
                cmbPort.Enabled = False
                cmbRate.Enabled = False
                cmbParity.Enabled = False
                cmbBits.Enabled = False
                cmbStop.Enabled = False
                btnConnect.Text = "Disconnect"
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub chkDTR_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkDTR.CheckedChanged
        serCOM.DtrEnable = chkDTR.Checked
    End Sub

    Private Sub chkRTS_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkRTS.CheckedChanged
        serCOM.RtsEnable = chkRTS.Checked
    End Sub

    Private Sub serCOM_DataReceived(ByVal sender As System.Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles serCOM.DataReceived
        Dim rx_buffer(1024) As Byte
        Dim rx_size As Integer
        Dim i As Integer

        rx_size = serCOM.BytesToRead

        serCOM.Read(rx_buffer, 0, rx_size)


        txtRXi.Text = Hex$(rx_buffer(rx_size - 1))
        txtRX.ScrollToCaret()

        For i = 0 To rx_size - 1
            txtRX.AppendText(Hex$(rx_buffer(i)) + " ")
            If Asc(rx_buffer(i)) = START Then
                rx_data(0) = START
                rx_i = 1
            ElseIf rx_i <= 7 Then
                rx_data(rx_i) = Asc(rx_buffer(i))
                rx_i = rx_i + 1
            End If
            If rx_i = 8 Then
                rx()
            End If
        Next

        serCOM.DiscardInBuffer()
    End Sub

    Private Sub btnTX_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTX.Click
        If serCOM.IsOpen Then
            If chkBreak.Checked = True Then
                serCOM.Write(txtTX.Text + vbCrLf)
                txtRX.AppendText(vbCrLf + ">ME>" + txtTX.Text + vbCrLf)
            Else
                serCOM.Write(txtTX.Text)
                txtRX.AppendText(vbCrLf + ">ME>" + txtTX.Text)
            End If
            txtRX.ScrollToCaret()
        End If
    End Sub

    Private Sub txtTX_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtTX.KeyPress
        If e.KeyChar = Chr(&HD) Then
            If serCOM.IsOpen Then
                If chkBreak.Checked = True Then
                    serCOM.Write(txtTX.Text + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + txtTX.Text + vbCrLf)
                Else
                    serCOM.Write(txtTX.Text)
                    txtRX.AppendText(vbCrLf + ">ME>" + txtTX.Text)
                End If
                txtRX.ScrollToCaret()
            End If
        End If
    End Sub

    Private Sub btnXBeeRate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnXBeeRate.Click
        If serCOM.IsOpen Then
            Select Case cmbXBeeRate.SelectedItem
                Case "1200 (ATBD0<CR>)"
                    serCOM.Write("ATBD0" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD0" + vbCrLf)
                    Exit Select
                Case "2400 (ATBD1<CR>)"
                    serCOM.Write("ATBD1" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD1" + vbCrLf)
                    Exit Select
                Case "4800 (ATBD2<CR>)"
                    serCOM.Write("ATBD2" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD2" + vbCrLf)
                    Exit Select
                Case "9600 (ATBD3<CR>)"
                    serCOM.Write("ATBD3" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD3" + vbCrLf)
                    Exit Select
                Case "19200 (ATBD4<CR>)"
                    serCOM.Write("ATBD4" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD4" + vbCrLf)
                    Exit Select
                Case "38400 (ATBD5<CR>)"
                    serCOM.Write("ATBD5" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD5" + vbCrLf)
                    Exit Select
                Case "57600 (ATBD6<CR>)"
                    serCOM.Write("ATBD6" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD6" + vbCrLf)
                    Exit Select
                Case "115200 (ATBD7<CR>)"
                    serCOM.Write("ATBD7" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATBD7" + vbCrLf)
                    Exit Select
                Case Else
                    Exit Select
            End Select
            txtRX.ScrollToCaret()
        End If
    End Sub

    Private Sub btnXBeeCommand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnXBeeCommand.Click
        If serCOM.IsOpen Then
            serCOM.Write("+++")
            txtRX.AppendText(vbCrLf + ">ME>" + "+++" + vbCrLf)
            txtRX.ScrollToCaret()
        End If
    End Sub

    Private Sub btnXBeeParity_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnXBeeParity.Click
        If serCOM.IsOpen Then
            Select Case cmbXBeeParity.SelectedItem
                Case "No Parity (ATNB0<CR>)"
                    serCOM.Write("ATNB0" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATNB0" + vbCrLf)
                    Exit Select
                Case "Even Parity (ATNB1<CR>)"
                    serCOM.Write("ATNB1" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATNB1" + vbCrLf)
                    Exit Select
                Case "Odd Parity (ATNB2<CR>)"
                    serCOM.Write("ATNB2" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATNB2" + vbCrLf)
                    Exit Select
                Case Else
                    Exit Select
            End Select
            txtRX.ScrollToCaret()
        End If
    End Sub

    Private Sub btnXBeeCh_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnXBeeCh.Click
        If serCOM.IsOpen Then
            Select Case cmbXBeeCh.SelectedItem
                Case "Default Channel (ATCH0C<CR>)"
                    serCOM.Write("ATCH0C" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATCH0C" + vbCrLf)
                    Exit Select
                Case "Red Channel (ATCH10<CR>)"
                    serCOM.Write("ATCH10" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATCH10" + vbCrLf)
                    Exit Select
                Case "Blue Channel (ATCH11<CR>)"
                    serCOM.Write("ATCH11" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATCH11" + vbCrLf)
                    Exit Select
                Case "Green Channel (ATCH12<CR>)"
                    serCOM.Write("ATCH12" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATCH12" + vbCrLf)
                    Exit Select
                Case "Yellow Channel (ATCH13<CR>)"
                    serCOM.Write("ATCH13" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATCH13" + vbCrLf)
                    Exit Select
                Case "Aux Channel (ATCH0D<CR>)"
                    serCOM.Write("ATCH0D" + vbCrLf)
                    txtRX.AppendText(vbCrLf + ">ME>" + "ATCH0D" + vbCrLf)
                    Exit Select
                Case Else
                    Exit Select
            End Select
            txtRX.ScrollToCaret()
        End If
    End Sub

    Private Sub btnMem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMem.Click
        If serCOM.IsOpen Then
            serCOM.Write("ATWR" + vbCrLf)
            txtRX.AppendText(vbCrLf + ">ME>" + "ATWR" + vbCrLf)
        End If
        txtRX.ScrollToCaret()
    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        If serCOM.IsOpen Then
            serCOM.Write("ATCN" + vbCrLf)
            txtRX.AppendText(vbCrLf + ">ME>" + "ATCN" + vbCrLf)
        End If
        txtRX.ScrollToCaret()
    End Sub

    Private Sub chkTXi_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkTXi.CheckedChanged
        tmrTX.Enabled = chkTXi.Checked
    End Sub

    Private Sub tmrTX_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrTX.Tick
        Dim tx_buffer(1024) As Byte

        If serCOM.IsOpen Then
            tx_buffer(0) = Val(txtTXi.Text)
            serCOM.Write(tx_buffer, 0, 1)
        End If
    End Sub

    Private Sub btnToggle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnToggle.Click
        Dim tx_buffer(8) As Byte
        Dim tx_crc As Byte
        Dim rflags As Byte
        Dim i As Integer

        tx_buffer(0) = START
        tx_buffer(1) = &H1
        tx_buffer(2) = &H0
        tx_buffer(3) = &H0
        tx_buffer(4) = &H0
        tx_buffer(5) = &H0

        tx_crc = CRC_SEED
        For i = 1 To 5
            tx_crc = CRC8LUT(tx_buffer(i) Xor tx_crc)
        Next
        tx_buffer(6) = tx_crc

        For i = 1 To 6
            If tx_buffer(i) = START Then
                tx_buffer(i) = &HFE
                rflags = rflags Or (&H1 * 2 ^ (i - 1))
            End If
        Next
        tx_buffer(7) = rflags

        If serCOM.IsOpen Then
            serCOM.Write(tx_buffer, 0, 8)
        End If

    End Sub

    Private Sub btnDuty_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDuty.Click
        Dim tx_buffer(8) As Byte
        Dim tx_crc As Byte
        Dim rflags As Byte
        Dim i As Integer

        tx_buffer(0) = START
        tx_buffer(1) = &H2
        If IsNumeric(txtDuty.Text) Then
            tx_buffer(2) = Val(txtDuty.Text) * 254 / 100
        Else
            tx_buffer(2) = 128
        End If
        tx_buffer(3) = &H0
        tx_buffer(4) = &H0
        tx_buffer(5) = &H0

        tx_crc = CRC_SEED
        For i = 1 To 5
            tx_crc = CRC8LUT(tx_buffer(i) Xor tx_crc)
        Next
        tx_buffer(6) = tx_crc

        For i = 1 To 6
            If tx_buffer(i) = START Then
                tx_buffer(i) = &HFE
                rflags = rflags Or (&H1 * 2 ^ (i - 1))
            End If
        Next
        tx_buffer(7) = rflags

        If serCOM.IsOpen Then
            serCOM.Write(tx_buffer, 0, 8)
        End If
    End Sub

    Private Sub btnADC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnADC.Click
        Dim tx_buffer(8) As Byte
        Dim tx_crc As Byte
        Dim rflags As Byte
        Dim i As Integer

        tx_buffer(0) = START
        tx_buffer(1) = &H3
        If IsNumeric(txtADC.Text) Then
            tx_buffer(2) = Val(txtADC.Text)
        Else
            tx_buffer(2) = 128
        End If
        tx_buffer(3) = &H0
        tx_buffer(4) = &H0
        tx_buffer(5) = &H0

        tx_crc = CRC_SEED
        For i = 1 To 5
            tx_crc = CRC8LUT(tx_buffer(i) Xor tx_crc)
        Next
        tx_buffer(6) = tx_crc

        For i = 1 To 6
            If tx_buffer(i) = START Then
                tx_buffer(i) = &HFE
                rflags = rflags Or (&H1 * 2 ^ (i - 1))
            End If
        Next
        tx_buffer(7) = rflags

        If serCOM.IsOpen Then
            serCOM.Write(tx_buffer, 0, 8)
        End If
    End Sub

    Private Sub rx()
        ' attempt to process a received data packet

        Dim rflags As Integer = 0
        Dim i As Integer = 0
        Dim rx_crc As Byte

        ' replace escaped characters
        rflags = rx_data(7)
        For i = 1 To 6
            If (rflags And (&H1 * 2 ^ (i - 1))) <> 0 Then
                rx_data(i) = START
            End If
        Next

        ' compute CRC
        rx_crc = CRC_SEED
        For i = 1 To 5
            rx_crc = CRC8LUT(rx_data(i) Xor rx_crc)
        Next

        If rx_data(6) = rx_crc Then
            MsgBox("Passed CRC: " + Str(rx_data(3) * 4 + rx_data(4)))
        Else
            MsgBox("Failed CRC: " + Str(rx_data(3) * 4 + rx_data(4)))
        End If

        rx_i = 9

    End Sub
End Class
